package gql

import (
	"code.justin.tv/extensions/eastwatch/internal/models/token"
)

type ExtensionDocument struct {
	ID                  string         `json:"id"`
	Name                string         `json:"name"`
	ContentMatchedGames []Game         `json:"contentMatchedGames"`
	Views               ExtensionViews `json:"views"`
}

type ExtensionViews struct {
	Panel        *GeneralView `json:"panel"`
	VideoOverlay *GeneralView `json:"videoOverlay"`
	Component    *GeneralView `json:"component"`
}

type GeneralView struct {
	ViewerPath string `json:"viewerPath"`
	ViewerURL  string `json:"viewerUrl"`
}

func (c *client) GetExtensionByID(t token.OAuth, id string) (ExtensionDocument, error) {
	var out struct {
		Extension ExtensionDocument `json:"extension"`
	}

	op, found := c.query["extension"]
	if !found {
		return ExtensionDocument{}, ErrOperationNotFound
	}

	input := map[string]interface{}{
		"id": id,
	}

	b, err := c.executeQuery(t, op, input)
	if err != nil {
		return ExtensionDocument{}, err
	}

	err = b.Unmarshal(&out)
	if err != nil {
		return ExtensionDocument{}, err
	}

	return out.Extension, nil
}
