package gql

import (
	"code.justin.tv/extensions/eastwatch/internal/models/token"
	"code.justin.tv/gds/gds/extensions/ems/documents"
)

type getExtensionCategoriesResponse struct {
	ExtensionCategories extensionCategories `json:"extensionCategories"`
}

type extensionCategories struct {
	Edges    []extensionCategoriesEdge `json:"edges"`
	PageInfo pageInfo                  `json:"pageInfo"`
}

type extensionCategoriesEdge struct {
	Cursor   string   `json:"cursor"`
	Category category `json:"category"`
}

type category struct {
	ID          string             `json:"id"`
	Name        string             `json:"name"`
	Description string             `json:"description"`
	Extensions  categoryExtensions `json:"extensions"`
}

type categoryExtensions struct {
	Edges []extensionsEdge `json:"edges"`
}

func (c *client) GetExtensionCategories(t token.OAuth, first int, after string) ([]*ExtensionCategory, error) {
	var categories []*ExtensionCategory

	op, found := c.query["extension_categories"]
	if !found {
		return categories, ErrOperationNotFound
	}

	input := map[string]interface{}{
		"first": first,
		"after": after,
	}

	b, err := c.executeQuery(t, op, input)
	if err != nil {
		return categories, err
	}

	var res getExtensionCategoriesResponse

	err = b.Unmarshal(&res)
	if err != nil {
		return categories, err
	}

	for _, v := range res.ExtensionCategories.Edges {
		cat := ExtensionCategory{
			ID:          v.Category.ID,
			Name:        v.Category.Name,
			Description: v.Category.Description,
		}
		for _, e := range v.Category.Extensions.Edges {
			cat.Extensions = append(cat.Extensions, documents.ExtensionDocument{
				ID:               e.Extension.ClientID,
				AuthorName:       e.Extension.AuthorName,
				BitsSupportLevel: e.Extension.BitsSupportLevel,
				Name:             e.Extension.Name,
				State:            e.Extension.State,
				Summary:          e.Extension.Summary,
				Version:          e.Extension.Version,
			})
		}
		categories = append(categories, &cat)
	}

	return categories, nil
}
