package gql

import (
	"code.justin.tv/extensions/eastwatch/internal/models/token"
)

func (c *client) GetExtensionsForChannelCurrentUser(t token.OAuth, channelID string) (UserChannel, error) {
	op, found := c.query["extensions_for_channel_current_user"]
	if !found {
		return UserChannel{}, ErrOperationNotFound
	}

	input := map[string]string{"channelID": channelID}
	b, err := c.executeQuery(t, op, input)
	if err != nil {
		return UserChannel{}, err
	}

	var r UserChannel
	err = b.Unmarshal(&r)
	return r, err
}
