package gql

import (
	"code.justin.tv/extensions/eastwatch/internal/models/token"
	"code.justin.tv/gds/gds/extensions/ems/documents"
)

type getFeaturedScheduleResponse struct {
	ExtensionCarousel extensionCarousel `json:"extensionCarousel"`
}

type extensionCarousel struct {
	ID      string  `json:"id"`
	Entries []entry `json:"entries"`
}

type entry struct {
	ClickThroughURL string `json:"clickThroughURL"`
	ID              string `json:"id"`
	ImageURL        string `json:"imageURL"`
	Title           string `json:"title"`
}

func (c *client) GetFeaturedSchedule(t token.OAuth, scheduleID string) (documents.FeaturedCarouselDocument, error) {
	var carousel documents.FeaturedCarouselDocument

	op, found := c.query["get_featured_schedule"]
	if !found {
		return carousel, ErrOperationNotFound
	}

	input := map[string]string{
		"scheduleID": scheduleID,
	}

	b, err := c.executeQuery(t, op, input)
	if err != nil {
		return carousel, err
	}

	var resp getFeaturedScheduleResponse

	err = b.Unmarshal(&resp)
	if err != nil {
		return carousel, err
	}

	carousel.ID = resp.ExtensionCarousel.ID

	entries := make([]*documents.FeaturedCarouselEntryDocument, len(resp.ExtensionCarousel.Entries))

	for i, v := range resp.ExtensionCarousel.Entries {
		entries[i] = &documents.FeaturedCarouselEntryDocument{
			ID: v.ID,
		}
		ec := documents.FeaturedCarouselEntryContent{
			ClickThrough: v.ClickThroughURL,
			ImageURL:     v.ImageURL,
			Title:        v.Title,
		}
		entries[i].Content = ec
	}

	carousel.Entries = &documents.FeaturedCarouselEntriesDocument{
		Count:   len(resp.ExtensionCarousel.Entries),
		Entries: entries,
	}

	return carousel, nil
}
