package gql

import (
	"code.justin.tv/extensions/eastwatch/internal/models/token"
	"code.justin.tv/gds/gds/extensions/ems/documents"
)

type extensionRecommendations struct {
	Extension extension `json:"extension"`
}

func (c *client) GetExtensionRecommendations(t token.OAuth, gameID string) ([]documents.ExtensionDocument, error) {
	var out struct {
		Game Game `json:"game"`
	}

	extensions := make([]documents.ExtensionDocument, 0)

	op, found := c.query["game"]
	if !found {
		return extensions, ErrOperationNotFound
	}

	input := map[string]interface{}{
		"id": gameID,
	}

	b, err := c.executeQuery(t, op, input)
	if err != nil {
		return nil, err
	}

	err = b.Unmarshal(&out)
	if err != nil {
		return nil, err
	}

	for _, v := range out.Game.ExtensionRecommendations {
		extensions = append(extensions, documents.ExtensionDocument{
			ID:    v.Extension.ClientID,
			State: v.Extension.State,
		})
	}

	return extensions, nil
}
