package gql

import (
	"fmt"

	"code.justin.tv/extensions/eastwatch/internal/models/token"
)

// InstallExtensionError is the Error field of InstallExtension
type InstallExtensionError struct {
	Code           string `json:"code"`
	InstallationID string `json:"installationID"`
}

func (c *client) InstallExtension(t token.OAuth, manifestID, channelID string) (InstalledExtension, error) {
	var out struct {
		InstallExtension struct {
			InstalledExtension InstalledExtension     `json:"installedExtension"`
			Error              *InstallExtensionError `json:"error"`
		} `json:"installExtension"`
	}

	op, found := c.mutation["install_extension"]
	if !found {
		return InstalledExtension{}, ErrOperationNotFound
	}

	input := map[string]string{
		"extensionID": manifestID,
		"channelID":   channelID,
	}
	b, err := c.executeMutation(t, op, input)
	if err != nil {
		return InstalledExtension{}, err
	}

	err = b.Unmarshal(&out)
	if out.InstallExtension.Error != nil {
		for _, code := range ErrCodes {
			if out.InstallExtension.Error.Code == code {
				return InstalledExtension{}, out.InstallExtension.Error
			}
		}
		return InstalledExtension{}, fmt.Errorf("unhandled error: %s", out.InstallExtension.Error.Code)
	}
	if err != nil {
		return InstalledExtension{}, err
	}

	return out.InstallExtension.InstalledExtension, nil
}

func (e *InstallExtensionError) Error() string {
	return fmt.Sprintf("Code: %s", e.Code)
}
