package gql

import (
	"strings"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestLoadOperations(t *testing.T) {

	t.Run("should load mutation", func(t *testing.T) {
		ops, err := loadOperations("mutation")
		require.NoError(t, err)
		m, found := ops["create_extension_client"]
		require.True(t, found)
		assert.Equal(t, "mutation", m.Type)
		assert.Equal(t, "create_extension_client.graphql", m.FileName)
		assert.Equal(t, "create extension client", m.Name())
		assert.True(t, strings.HasPrefix(m.Contents, "mutation DevExtensionCreatePage_CreateExtensionClient("))
	})

	t.Run("should load query", func(t *testing.T) {
		ops, err := loadOperations("query")
		require.NoError(t, err)
		q, found := ops["extensions_for_channel_current_user"]
		require.True(t, found)
		assert.Equal(t, "query", q.Type)
		assert.Equal(t, "extensions_for_channel_current_user.graphql", q.FileName)
		assert.Equal(t, "extensions for channel current user", q.Name())
		assert.True(t, strings.HasPrefix(q.Contents, "query ExtensionsForChannelCurrentUser($channelID: ID!) {"))
	})
}
