package gql

import (
	"errors"

	"code.justin.tv/extensions/eastwatch/internal/models/token"
)

func (c *client) SaveDiscoveryData(t token.OAuth, input ExtensionDiscoveryManifestInput) (ExtensionManifest, error) {
	var body struct {
		SaveDiscoveryData struct {
			Error    string            `json:"error"`
			Manifest ExtensionManifest `json:"manifest"`
		} `json:"updateExtensionDiscoveryData"`
	}

	op, found := c.mutation["save_discovery_data"]
	if !found {
		return ExtensionManifest{}, ErrOperationNotFound
	}

	b, err := c.executeMutation(t, op, input)
	if err != nil {
		return ExtensionManifest{}, err
	}

	err = b.Unmarshal(&body)
	if err != nil {
		return ExtensionManifest{}, err
	}

	// domain error returned as part of the operation
	if body.SaveDiscoveryData.Error != "" {
		return ExtensionManifest{}, errors.New(body.SaveDiscoveryData.Error)
	}

	return body.SaveDiscoveryData.Manifest, nil
}
