package gql

import (
	"code.justin.tv/extensions/eastwatch/internal/models/token"
	"code.justin.tv/gds/gds/extensions/ems/documents"
)

type searchExtensionsResponse struct {
	Extension searchExtensionsExtensions `json:"extensions"`
}

type searchExtensionsExtensions struct {
	Edges      []searchExtensionsEdge `json:"edges"`
	PageInfo   pageInfo               `json:"pageInfo"`
	TotalCount int                    `json:"totalCount"`
}

type searchExtensionsEdge struct {
	Extension extension `json:"extension"`
	Cursor    string    `json:"cursor"`
}

func (c *client) SearchExtensions(t token.OAuth, first int, after, search string) ([]documents.ExtensionDocument, int, error) {
	extensions := make([]documents.ExtensionDocument, 0)

	op, found := c.query["extensions"]
	if !found {
		return extensions, 0, ErrOperationNotFound
	}

	input := map[string]interface{}{
		"first":  first,
		"after":  after,
		"search": search,
	}

	b, err := c.executeQuery(t, op, input)
	if err != nil {
		return extensions, 0, err
	}

	var res searchExtensionsResponse

	err = b.Unmarshal(&res)
	if err != nil {
		return extensions, 0, err
	}

	for _, v := range res.Extension.Edges {
		if err != nil {
			return extensions, 0, err
		}
		extensions = append(extensions, documents.ExtensionDocument{
			ID:          v.Extension.ClientID,
			Version:     v.Extension.Version,
			Name:        v.Extension.Name,
			Summary:     v.Extension.Summary,
			Description: v.Extension.Description,
			State:       v.Extension.State,
		})
	}

	//fmt.Printf("%s:%s %s\n", extensions[0].ID, extensions[0].Version, extensions[0].Summary)

	return extensions, res.Extension.TotalCount, nil
}
