package gql

import (
	"fmt"

	"code.justin.tv/extensions/eastwatch/internal/models/token"
)

type SetExtensionFeatureFlagsInput struct {
	InstallationID    string                   `json:"id"`
	CanSentChat       bool                     `json:"canSendChat"`
	CanUseBits        bool                     `json:"canUseBits"`
	DynamicManagement []DynamicManagementInput `json:"dynamicManagement"`
}

type DynamicManagementInput struct {
	GameID    string `json:"gameID"`
	IsManaged bool   `json:"isManaged"`
}

// SetExtensionFeatureFlagsError is the Error field of SetExtensionFeatureFlags
type SetExtensionFeatureFlagsError struct {
	Code                  string `json:"code"`
	MissingInstallationID string `json:"missingInstallationID"`
}

func (c *client) SetExtensionFeatureFlags(t token.OAuth, input SetExtensionFeatureFlagsInput) (InstalledExtension, error) {
	var out struct {
		SetExtensionFeatureFlags struct {
			InstalledExtension InstalledExtension             `json:"installedExtension"`
			Error              *SetExtensionFeatureFlagsError `json:"error"`
		} `json:"setExtensionFeatureFlags"`
	}

	op, found := c.mutation["set_extension_feature_flags"]
	if !found {
		return InstalledExtension{}, ErrOperationNotFound
	}

	b, err := c.executeMutation(t, op, input)
	if err != nil {
		return InstalledExtension{}, err
	}

	err = b.Unmarshal(&out)
	if out.SetExtensionFeatureFlags.Error != nil {
		for _, code := range ErrCodes {
			if out.SetExtensionFeatureFlags.Error.Code == code {
				return InstalledExtension{}, out.SetExtensionFeatureFlags.Error
			}
		}
		return InstalledExtension{}, fmt.Errorf("unhandled error: %s", out.SetExtensionFeatureFlags.Error.Code)
	}
	if err != nil {
		return InstalledExtension{}, err
	}

	return out.SetExtensionFeatureFlags.InstalledExtension, nil
}

func (e *SetExtensionFeatureFlagsError) Error() string {
	return fmt.Sprintf("Code: %s", e.Code)
}
