package gql

import (
	"fmt"

	"code.justin.tv/extensions/eastwatch/internal/models/token"
)

// UninstallExtensionError is the Error field of UninstallExtension
type UninstallExtensionError struct {
	Code string `json:"code"`
}

func (c *client) UninstallExtension(t token.OAuth, installationID string) (string, error) {
	var out struct {
		UninstallExtension struct {
			InstallationID string                   `json:"id"` // ID:Version:Channel
			Error          *UninstallExtensionError `json:"error"`
		} `json:"uninstallExtension"`
	}

	op, found := c.mutation["uninstall_extension"]
	if !found {
		return "", ErrOperationNotFound
	}

	input := map[string]string{"extensionInstallationID": installationID}
	b, err := c.executeMutation(t, op, input)
	if err != nil {
		return "", err
	}

	err = b.Unmarshal(&out)
	if out.UninstallExtension.Error != nil {
		if out.UninstallExtension.Error.Code != ErrCodeExtensionNotInstalled { // ErrCodeExtensionNotInstalled count as success
			for _, code := range ErrCodes {
				if out.UninstallExtension.Error.Code == code {
					return "", out.UninstallExtension.Error
				}
			}
			return "", fmt.Errorf("unhandled error: %s", out.UninstallExtension.Error.Code)
		}
	}
	if err != nil {
		return "", err
	}

	return out.UninstallExtension.InstallationID, nil
}

func (e *UninstallExtensionError) Error() string {
	return fmt.Sprintf("Code: %s", e.Code)
}
