package gql

import (
	"code.justin.tv/extensions/eastwatch/internal/models/token"
)

func (c *client) UpdateBroadcastSettings(t token.OAuth, channelID, gameName string) (string, error) {
	var out struct {
		UpdateBroadcastSettings struct {
			BroadcastSettings struct {
				Game *Game `json:"game"`
			} `json:"broadcastSettings"`
		} `json:"updateBroadcastSettings"`
	}

	op, found := c.mutation["update_broadcast_settings"]
	if !found {
		return "", ErrOperationNotFound
	}

	input := map[string]string{
		"userID": channelID,
		"game":   gameName,
	}
	b, err := c.executeMutation(t, op, input)
	if err != nil {
		return "", err
	}

	err = b.Unmarshal(&out)
	if err != nil {
		return "", err
	}

	if out.UpdateBroadcastSettings.BroadcastSettings.Game != nil {
		return out.UpdateBroadcastSettings.BroadcastSettings.Game.ID, nil
	}

	return "", nil
}
