package owl

import (
	"code.justin.tv/extensions/eastwatch/internal/models/token"
	owlclient "code.justin.tv/web/owl/client"
	"code.justin.tv/web/owl/oauth2"
)

//go:generate counterfeiter -o owlfakes/fake_owl_client.go --fake-name FakeOwlClient ../../../vendor/code.justin.tv/web/owl/client Client
type Client interface {

	// GetAppAccessToken gets the app access token from Owl.
	GetAppAccessToken(clientID string, secret string) (token.OAuth, error)

	// GetClients calls Owl to get a list of clients for a given userID
	GetClients(userID string) ([]*oauth2.Client, error)

	// DeleteClient deletes a given Client/Extension ID from Owl
	DeleteClient(userID, extID string) error

	// CreateExtensionClient creates a client in Owl with IsExtension set to true
	CreateExtensionClient(userID, name string) (string, error)
}

type client struct {
	client owlclient.Client
}

// NewOwlClient instantiates a new Owl object/client
func NewClient(c owlclient.Client) Client {
	return &client{c}
}
