package owl

import (
	"code.justin.tv/web/owl/client"
	"context"
	"github.com/pkg/errors"
	"net/url"
	"strconv"
)

// Creates a client in Owl, marked as an extension. Returns the extensions ID
func (o *client) CreateExtensionClient(userID, name string) (string, error) {
	ctx := context.Background()

	ownerID, err := strconv.Atoi(userID)
	if err != nil {
		return "", errors.New("userID has to be an int looking string")
	}
	request := owl.CreateClientRequest{
		IsExtension:     true,
		OwnerID:         ownerID,
		Name:            name,
		RedirectURI:     "https://twitch.tv/",
		OauthCategoryID: 9,
		Category:        "Extension",
	}

	c, err := o.client.CreateClient(ctx, request, url.Values{owl.UserIDParam: {userID}}, nil)
	if err != nil {
		return "", err
	}
	return c.ClientID, nil
}
