package owl

import (
	"context"
	"fmt"

	"code.justin.tv/extensions/eastwatch/internal/models/token"
)

// GetAppAccessToken token gets the app access token from Owl.
func (o *client) GetAppAccessToken(clientID string, secret string) (token.OAuth, error) {

	ctx := context.Background()

	resp, err := o.client.ExchangeClientCredentials(ctx, clientID, secret, nil, nil)

	if err != nil {
		return "", fmt.Errorf("GetAppAccessToken failed: %s", err.Error())
	}

	return token.NewOAuth(resp.AccessToken)
}
