package owl

import (
	owlclient "code.justin.tv/web/owl/client"
	"code.justin.tv/web/owl/oauth2"
	"context"
)

// GetClients calls Owl to get a list of clients for a given userID
func (o *client) GetClients(userID string) ([]*oauth2.Client, error) {

	ctx := context.Background()
	filters := map[owlclient.FilterableColumn]string{
		owlclient.FilterColOwnerID: userID,
	}
	clients, _, err := o.client.GetClients(ctx, "", true, true, filters,
		owlclient.SortKeyClientID, owlclient.SortAsc, nil)

	if err != nil {
		return nil, err
	}

	return clients, nil

}
