package panel

import (
	"context"
	"io"
	"net/http"
	"net/url"

	"code.justin.tv/extensions/eastwatch/internal/metrics"
)

//go:generate counterfeiter . Client

type Client interface {

	// GetChannelPanels gets all of the panels associated to a channel
	GetChannelPanels(channelID string) ([]Panel, error)
}

type client struct {
	http        *http.Client
	baseURL     *url.URL
	ServiceName string
}

func NewClient(http *http.Client, baseURL string) (Client, error) {
	u, err := url.Parse(baseURL)
	if err != nil {
		return nil, err
	}
	return &client{
		http:        http,
		baseURL:     u,
		ServiceName: "Panels",
	}, nil
}

func (c *client) buildRequest(ctx context.Context, operationName string, method string, url string, body io.Reader) (*http.Request, error) {
	d := metrics.Dimensions{
		DependencyServiceName:   c.ServiceName,
		DependencyOperationName: operationName,
	}

	ctx = metrics.ContextWithDimensions(ctx, d)

	req, err := http.NewRequest(method, url, body)
	if err != nil {
		return nil, err
	}

	return req.WithContext(ctx), nil

}
