package panel

import (
	"context"
	"encoding/json"
	"fmt"
	"net/http"
	"net/url"
	"path"
)

type Panel struct {
	ID              int    `json:"id"`
	UserID          int    `json:"user_id"`
	DisplayOrder    int    `json:"display_order"`
	Kind            string `json:"kind"`
	Data            Data   `json:"data"`
	HTMLDescription string `json:"html_description"`
}

type Data struct {
	Description string `json:"description"`
	Slot        string `json:"slot"`
}

func (c *client) GetChannelPanels(channelID string) ([]Panel, error) {

	//GET /v1/users/:channel_id/panels?include_extensions=1
	path, err := url.Parse(path.Join("v1/users", channelID, "panels"))
	if err != nil {
		return nil, err
	}
	u := c.baseURL.ResolveReference(path)
	q := u.Query()
	q.Set("include_extensions", "1")
	u.RawQuery = q.Encode()

	req, err := c.buildRequest(context.Background(), "GetChannelPanels", http.MethodGet, u.String(), nil)
	if err != nil {
		return nil, err
	}

	resp, err := c.http.Do(req)
	if err != nil {
		return nil, err
	}

	if resp.StatusCode != http.StatusOK {
		return nil, fmt.Errorf("get channel panels unsuccessful [%s]", resp.Status)
	}

	var out struct {
		Panels []Panel `json:"panels"`
	}
	err = json.NewDecoder(resp.Body).Decode(&out)
	if err != nil {
		return nil, err
	}
	if len(out.Panels) == 0 {
		return nil, nil
	}
	return out.Panels, nil
}
