package visage

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"net/http"
	"net/url"

	"code.justin.tv/extensions/eastwatch/internal/models/token"
	"code.justin.tv/gds/gds/extensions/ems/documents"
)

func (c *client) AddCategory(t token.OAuth, r documents.AddCategoryRequest) (*documents.CategoryDocument, error) {
	//POST v5/categories

	u, err := url.Parse("v5/categories")
	if err != nil {
		return nil, err
	}

	body, err := json.Marshal(r)
	if err != nil {
		return nil, err
	}

	req, err := c.buildRequest(context.Background(), "AddCategory",
		http.MethodPost, c.baseURL.ResolveReference(u).String(), bytes.NewBuffer(body))
	if err != nil {
		return nil, err
	}

	req.Header.Set("Authorization", t.HeaderValue())
	req.Header.Set("Content-Type", "application/json")

	resp, err := c.http.Do(req)
	if err != nil {
		return nil, err
	}

	if resp.StatusCode != http.StatusOK {
		return nil, fmt.Errorf("add category unsuccessful [%s]", resp.Status)
	}

	var cat documents.CategoryDocument
	err = json.NewDecoder(resp.Body).Decode(&cat)
	if err != nil {
		return nil, err
	}

	return &cat, nil
}
