package visage

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"net/http"
	"net/url"

	"code.justin.tv/extensions/eastwatch/internal/models/token"
	"code.justin.tv/gds/gds/extensions/ems/documents"
)

func (c *client) AddFeaturedCarousel(t token.OAuth, r documents.AddFeaturedCarouselRequest) (*documents.FeaturedCarouselDocument, error) {
	//POST v5/featured_carousels
	path, err := url.Parse("v5/featured_carousels")
	if err != nil {
		return nil, err
	}

	body, err := json.Marshal(r)
	if err != nil {
		return nil, err
	}

	req, err := c.buildRequest(context.Background(), "AddFeaturedCarousel", http.MethodPost, c.baseURL.ResolveReference(path).String(), bytes.NewBuffer(body))
	if err != nil {
		return nil, err
	}

	req.Header.Set("Authorization", t.HeaderValue())
	req.Header.Set("Content-Type", "application/json")

	resp, err := c.http.Do(req)
	if err != nil {
		return nil, err
	}

	if resp.StatusCode != http.StatusOK {
		return nil, fmt.Errorf("add featured carousel unsuccessful [%s]", resp.Status)
	}

	var carousel documents.FeaturedCarouselDocument
	err = json.NewDecoder(resp.Body).Decode(&carousel)
	if err != nil {
		return nil, err
	}

	return &carousel, nil
}
