package visage

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"net/http"
	"net/url"

	"code.justin.tv/extensions/eastwatch/internal/models/token"
	"code.justin.tv/gds/gds/extensions/ems/documents"
)

func (c *client) AddFeaturedCarouselEntry(t token.OAuth, r documents.AddFeaturedCarouselEntryRequest) (*documents.FeaturedCarouselEntryDocument, error) {
	//POST v5/featured_carousel_entries

	path, err := url.Parse("v5/featured_carousel_entries")
	if err != nil {
		return nil, err
	}

	body, err := json.Marshal(r)
	if err != nil {
		return nil, err
	}

	req, err := c.buildRequest(context.Background(), "AddFeaturedCarouselEntry", http.MethodPost, c.baseURL.ResolveReference(path).String(), bytes.NewBuffer(body))
	if err != nil {
		return nil, err
	}

	req.Header.Set("Authorization", t.HeaderValue())
	req.Header.Set("Content-Type", "application/json")

	resp, err := c.http.Do(req)
	if err != nil {
		return nil, err
	}

	if resp.StatusCode != http.StatusOK {
		return nil, fmt.Errorf("add featured carousel entry unsuccessful [%s]", resp.Status)
	}

	var entry documents.FeaturedCarouselEntryDocument
	err = json.NewDecoder(resp.Body).Decode(&entry)
	return &entry, err
}
