package visage

import (
	"context"
	"encoding/json"
	"fmt"
	"net/http"
	"net/url"
	"path"

	"code.justin.tv/extensions/eastwatch/internal/models/token"
	"code.justin.tv/gds/gds/extensions/ems/documents"
)

func (c *client) DeleteCategory(t token.OAuth, categoryID string) (documents.CategoryDocument, error) {
	//DELETE /v5/categories/:cid
	var out documents.CategoryDocument

	path, err := url.Parse(path.Join("v5/categories/", categoryID))
	if err != nil {
		return out, err
	}

	req, err := c.buildRequest(context.Background(), "DeleteCategory", http.MethodDelete, c.baseURL.ResolveReference(path).String(), nil)
	if err != nil {
		return out, err
	}

	req.Header.Set("Authorization", t.HeaderValue())

	resp, err := c.http.Do(req)
	if err != nil {
		return out, err
	}

	if resp.StatusCode != http.StatusOK {
		return out, fmt.Errorf("delete category unsuccessful [%s]", resp.Status)
	}

	err = json.NewDecoder(resp.Body).Decode(&out)
	return out, err
}
