package visage

import (
	"context"
	"encoding/json"
	"fmt"
	"net/http"
	"net/url"
	"path"

	"code.justin.tv/extensions/eastwatch/internal/models/token"
	"code.justin.tv/gds/gds/extensions/ems/documents"
)

func (c *client) DeleteFeaturedCarouselEntry(t token.OAuth, entryID string) (*documents.FeaturedCarouselEntryDocument, error) {
	//DELETE v5/featured_carousel_entries/:fceid

	path, err := url.Parse(path.Join("v5/featured_carousel_entries", entryID))
	if err != nil {
		return nil, err
	}

	req, err := c.buildRequest(context.Background(), "DeleteFeaturedCarouselEntry", http.MethodDelete, c.baseURL.ResolveReference(path).String(), nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Authorization", t.HeaderValue())
	req.Header.Set("Content-Type", "application/json")

	resp, err := c.http.Do(req)
	if err != nil {
		return nil, err
	}

	if resp.StatusCode != http.StatusOK {
		return nil, fmt.Errorf("delete featured carousel entry unsuccessful [%s]", resp.Status)
	}

	var entry documents.FeaturedCarouselEntryDocument
	err = json.NewDecoder(resp.Body).Decode(&entry)
	return &entry, err
}
