package visage

import (
	"context"
	"encoding/json"
	"fmt"
	"net/http"
	"net/url"
	"path"

	"code.justin.tv/extensions/eastwatch/internal/config"
	"code.justin.tv/extensions/eastwatch/internal/models/token"
	"code.justin.tv/gds/gds/extensions/ems/documents"
)

func (c *client) GetExtensionByID(t token.OAuth, extensionID, version string) (documents.ExtensionDocument, error) {
	var out documents.ExtensionDocument

	//GET /extension/:eid/:extension_version
	path, err := url.Parse(path.Join("v5/extensions", extensionID, version))
	if err != nil {
		return out, err
	}

	req, err := c.buildRequest(context.Background(), "GetExtensionByID", http.MethodGet, c.baseURL.ResolveReference(path).String(), nil)
	if err != nil {
		return out, err
	}

	if t != token.OAuthEmpty {
		req.Header.Set("Authorization", t.HeaderValue())
	} else {
		req.Header.Set("Client-ID", config.AnonymousClientID)
	}

	resp, err := c.http.Do(req)
	if err != nil {
		return out, err
	}
	if resp.StatusCode != http.StatusOK {
		return out, fmt.Errorf("get extension by id unsuccessful [%s]", resp.Status)
	}

	err = json.NewDecoder(resp.Body).Decode(&out)
	return out, err

}
