package visage

import (
	"context"
	"encoding/json"
	"fmt"
	"net/http"
	"net/url"
	"path"

	"code.justin.tv/extensions/eastwatch/internal/config"
	"code.justin.tv/extensions/eastwatch/internal/models/token"
	"code.justin.tv/gds/gds/extensions/ems/documents"
)

func (c *client) GetExtensionsByChannelID(t token.OAuth, channelID string) (documents.InstalledExtensionsDocument, error) {
	var out documents.InstalledExtensionsDocument

	// GET /channels/:cid/extensions
	path, err := url.Parse(path.Join("v5/channels", channelID, "extensions"))
	if err != nil {
		return out, err
	}

	req, err := c.buildRequest(context.Background(), "GetExtensionsByChannelID", http.MethodGet, c.baseURL.ResolveReference(path).String(), nil)
	if err != nil {
		return out, err
	}
	if t != token.OAuthEmpty {
		req.Header.Set("Authorization", t.HeaderValue())
	} else {
		req.Header.Set("Client-ID", config.AnonymousClientID)
	}

	resp, err := c.http.Do(req)
	if err != nil {
		return out, err
	}
	if resp.StatusCode != http.StatusOK {
		return out, fmt.Errorf("get extensions by channel id unsuccessful [%s]", resp.Status)
	}

	err = json.NewDecoder(resp.Body).Decode(&out)
	return out, err
}
