package visage

import (
	"context"
	"encoding/json"
	"fmt"
	"net/http"
	"net/url"
	"strconv"

	"code.justin.tv/extensions/eastwatch/internal/models/token"
	"code.justin.tv/gds/gds/extensions/ems/documents"
)

func (c *client) GetFeaturedCarousels(t token.OAuth, offset int, limit int) (*documents.FeaturedCarouselsDocument, error) {
	//GET /v5/featured_carousels
	path, err := url.Parse("v5/featured_carousels")
	if err != nil {
		return nil, err
	}
	q := path.Query()
	q.Set("limit", strconv.Itoa(limit))
	q.Set("offset", strconv.Itoa(offset))
	path.RawQuery = q.Encode()

	req, err := c.buildRequest(context.Background(), "GetFeaturedCarousels", http.MethodGet, c.baseURL.ResolveReference(path).String(), nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Authorization", t.HeaderValue())
	req.Header.Set("Content-Type", "application/json")

	resp, err := c.http.Do(req)
	if err != nil {
		return nil, err
	}
	if resp.StatusCode != http.StatusOK {
		return nil, fmt.Errorf("get featured carousels unsuccessful [%s]", resp.Status)
	}

	var carousels documents.FeaturedCarouselsDocument
	err = json.NewDecoder(resp.Body).Decode(&carousels)
	return &carousels, err

}
