package visage

import (
	"context"
	"encoding/json"
	"fmt"
	"net/http"
	"net/url"
	"strconv"

	"code.justin.tv/extensions/eastwatch/internal/models/token"
	"code.justin.tv/gds/gds/extensions/ems/documents"
)

func (c *client) GetFeaturedSchedules(t token.OAuth, offset int, limit int) (*documents.FeaturedSchedulesDocument, error) {
	//GET /v5/featured_schedules
	path, err := url.Parse("v5/featured_schedules")
	if err != nil {
		return nil, err
	}
	u := c.baseURL.ResolveReference(path)
	q := u.Query()
	q.Set("offset", strconv.Itoa(offset))
	q.Set("limit", strconv.Itoa(limit))
	u.RawQuery = q.Encode()

	req, err := c.buildRequest(context.Background(), "GetFeaturedSchedules", http.MethodGet, u.String(), nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Authorization", t.HeaderValue())
	req.Header.Set("Content-Type", "application/json")

	resp, err := c.http.Do(req)
	if err != nil {
		return nil, err
	}

	if resp.StatusCode != http.StatusOK {
		return nil, fmt.Errorf("get featured schedules unsuccessful [%s]", resp.Status)
	}

	var schedules documents.FeaturedSchedulesDocument
	err = json.NewDecoder(resp.Body).Decode(&schedules)
	if err != nil {
		return nil, err
	}

	return &schedules, nil

}
