package visage

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"net/http"
	"net/url"
	"path"

	"code.justin.tv/gds/gds/extensions/ems/documents"

	"code.justin.tv/extensions/eastwatch/internal/models/token"
)

func (c *client) OrderCategory(t token.OAuth, categoryID string, r documents.OrderCategoryRequest) (*documents.CategoryDocument, error) {
	u, err := url.Parse(path.Join("v5/categories", categoryID, "order"))
	if err != nil {
		return nil, err
	}

	body, err := json.Marshal(r)
	if err != nil {
		return nil, err
	}

	req, err := c.buildRequest(context.Background(), "OrderCategory", http.MethodPost, c.baseURL.ResolveReference(u).String(), bytes.NewBuffer(body))
	if err != nil {
		return nil, err
	}

	req.Header.Set("Authorization", t.HeaderValue())
	req.Header.Set("Content-Type", "application/json")

	resp, err := c.http.Do(req)
	if err != nil {
		return nil, err
	}

	if resp.StatusCode != http.StatusOK {
		return nil, fmt.Errorf("order category unsuccessful [%s]", resp.Status)
	}

	var cat documents.CategoryDocument
	err = json.NewDecoder(resp.Body).Decode(&cat)
	if err != nil {
		return nil, err
	}

	return &cat, nil
}
