package visage

import (
	"context"
	"encoding/json"
	"fmt"
	"net/http"
	"net/url"
	"path"

	"code.justin.tv/extensions/eastwatch/internal/models/token"
	"code.justin.tv/gds/gds/extensions/ems/documents"
)

func (c *client) RemoveExtensionFromCategory(t token.OAuth, categoryID string, extensionID string) (*documents.ExtensionCategoryMembershipDocument, error) {
	//DELETE v5/categories/:cid/extensions/:eid
	u, err := url.Parse(path.Join("v5/categories", categoryID, "extensions", extensionID))
	if err != nil {
		return nil, err
	}

	req, err := c.buildRequest(context.Background(), "RemoveExtensionFromCategory", http.MethodDelete, c.baseURL.ResolveReference(u).String(), nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Authorization", t.HeaderValue())
	req.Header.Set("Content-Type", "application/json")

	resp, err := c.http.Do(req)
	if err != nil {
		return nil, err
	}

	if resp.StatusCode != http.StatusOK {
		return nil, fmt.Errorf("remove extension from category unsuccessful [%s]", resp.Status)
	}

	var membership documents.ExtensionCategoryMembershipDocument
	err = json.NewDecoder(resp.Body).Decode(&membership)
	if err != nil {
		return nil, err
	}

	return &membership, nil

}
