package visage

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"net/http"
	"net/url"
	"path"

	"code.justin.tv/extensions/eastwatch/internal/models/token"
	"code.justin.tv/gds/gds/extensions/ems/data"
)

// TransitionExtensionStateRequest is the body required for the request
type TransitionExtensionStateRequest struct {
	ExtensionID      string              `json:"-"`
	ExtensionVersion string              `json:"-"`
	State            data.ExtensionState `json:"state"`
}

func (c *client) TransitionExtensionState(t token.OAuth, r TransitionExtensionStateRequest) error {
	// PUT /v5/extensions/:extension_id/:extension_version
	u, err := url.Parse(path.Join("v5/extensions", r.ExtensionID, r.ExtensionVersion))
	if err != nil {
		return err
	}

	body, err := json.Marshal(r)
	if err != nil {
		return err
	}

	req, err := c.buildRequest(context.Background(), "TransitionExtensionState", http.MethodPut, c.baseURL.ResolveReference(u).String(), bytes.NewBuffer(body))
	if err != nil {
		return err
	}
	req.Header.Set("Authorization", t.HeaderValue())
	req.Header.Set("Content-Type", "application/json")

	resp, err := c.http.Do(req)
	if err != nil {
		return err
	}
	if resp.StatusCode != http.StatusNoContent {
		return fmt.Errorf("transition extension state unsuccessful [%s]", resp.Status)
	}

	return nil
}
