package visage

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"net/http"
	"net/url"
	"path"

	"code.justin.tv/extensions/eastwatch/internal/models/token"
	"code.justin.tv/gds/gds/extensions/ems/documents"
)

func (c *client) UpdateFeaturedCarouselEntry(t token.OAuth, r documents.AddFeaturedCarouselEntryRequest) (*documents.FeaturedCarouselEntryDocument, error) {
	//PUT v5/featured_carousel_entries/:fcid

	if r.CarouselID == nil {
		return nil, errors.New("invalid carousel id")
	}

	path, err := url.Parse(path.Join("v5/featured_carousel_entries", *r.CarouselID))
	if err != nil {
		return nil, err
	}

	body, err := json.Marshal(r)
	if err != nil {
		return nil, err
	}

	req, err := c.buildRequest(context.Background(), "UpdateFeaturedCarouselEntry", http.MethodPut, c.baseURL.ResolveReference(path).String(), bytes.NewBuffer(body))
	if err != nil {
		return nil, err
	}

	req.Header.Set("Authorization", t.HeaderValue())
	req.Header.Set("Content-Type", "application/json")

	resp, err := c.http.Do(req)
	if err != nil {
		return nil, err
	}

	if resp.StatusCode != http.StatusOK {
		return nil, fmt.Errorf("update featured carousel entry unsuccessful [%s]", resp.Status)
	}

	var entry documents.FeaturedCarouselEntryDocument
	err = json.NewDecoder(resp.Body).Decode(&entry)
	return &entry, err
}
