// Package config contains Eastwatch configuration setup and data
package config

// Configuration defines the configuration of eastwatch (this can probably be unexported)
type Configuration struct {
	VisageURL         string
	GQLURL            string
	CartmanURL        string
	OwlURL            string
	EMSURL            string
	PanelURL          string
	SandstormARN      string
	BaseSandstormPath string
	ClientID          string
	AppClientSecret   string
}

var (
	// Staging is the configuration for staging endpoints and users
	Staging = Configuration{
		VisageURL:         "https://jenkins.staging.visage-dev.twitch.a2z.com/",
		GQLURL:            "https://dev-graphql.twitch.a2z.com/master/gql",
		CartmanURL:        "http://cartman-staging-elb.dev.us-west2.justin.tv/",
		OwlURL:            "http://owl.prod.internal.us-west-2.twitch.tv/",
		EMSURL:            "https://staging.ems.extensions.twitch.a2z.com/",
		PanelURL:          "https://staging.panels.extensions.twitch.a2z.com",
		SandstormARN:      "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/extensions-eastwatch-staging",
		BaseSandstormPath: "developer-success/extensions/twitch-gds-dev/",
		ClientID:          "4uk3lq77ju8xu3dstfosfs4yh7a3fb",
		AppClientSecret:   "eastwatch-app-client-secret",
	}
)

const (
	// SiteTwilight is the Twitch mainsite
	SiteTwilight Site = "twilight"

	// SiteDevsite is the Twitch devsite
	SiteDevsite Site = "devsite"

	// AnonymousClientID is the client-id used when there is no OAuth token specified
	AnonymousClientID = "ps1pu6on4i1x19vo6pgcjyzckr7kr1"
)

// Site references a site in a configuration context (twilight or dev)
type Site string

func (s Site) String() string {
	return string(s)
}
