package config

import (
	"time"

	"code.justin.tv/systems/sandstorm/manager"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/credentials/stscreds"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/sts"
)

// GetSandstormSecret gets the value of a secret from sandstorm
func GetSandstormSecret(sandstormARN, secretName string) (string, error) {
	awsConfig := &aws.Config{Region: aws.String("us-west-2")}
	awsSession, err := session.NewSession(awsConfig)

	if err != nil {
		return "", err
	}

	assumeRoleProvider := &stscreds.AssumeRoleProvider{
		Duration:     900 * time.Second,
		ExpiryWindow: 10 * time.Second,
		RoleARN:      sandstormARN,
		Client:       sts.New(awsSession),
	}

	awsConfig.WithCredentials(credentials.NewCredentials(assumeRoleProvider))

	sandstormConfig := &manager.Config{
		AWSConfig: awsConfig,
		TableName: "sandstorm-production",
		KeyID:     "alias/sandstorm-production",
	}

	sandstormClient := manager.New(*sandstormConfig)
	secret, err := sandstormClient.Get(secretName)

	if err != nil {
		return "", err
	}

	return string(secret.Plaintext), nil
}
