package simplebootstrap

import (
	"code.justin.tv/amzn/C7-go/c7"
	"code.justin.tv/amzn/TwitchLogging"
	"code.justin.tv/amzn/TwitchProcessIdentifier"
	"code.justin.tv/amzn/TwitchTelemetry"
	"code.justin.tv/video/metricmiddleware-beta/operation"
)

// FultonBootstrap is the root configuration object which is handed to an application to startup
//   this struct provides core features such as logging, config, and processAddress
type FultonBootstrap struct {
	C7                *c7.C7
	Logger            logging.Logger
	OperationStarter  *operation.Starter
	ProcessIdentifier *identifier.ProcessIdentifier
	SampleReporter    telemetry.SampleReporter
}

// FultonCustomMembers allows customers to pass in their preferred interface implementations for the bootstrap
type FultonCustomMembers struct {
	// Logger to use (recommended to be a structured logger, such as a logger that outputs JSON)
	Logger logging.Logger
	// SampleObserver to use, can be either buffered or unbuffered depending on implementations
	SampleObserver telemetry.SampleObserver
	// AutoFlushMetrics represents whether to flush metrics every request, recommended true for lambda and false for
	// anything else (false = batch metrics across calls, true = make metric network calls for every incoming request,
	// blocking on network calls)
	AutoFlushMetrics bool
}

// CommonSimpleBootstrap represents the bootstrap process that all Fulton services (Lambda, ECS, etc) go through
func CommonSimpleBootstrap(tPid *identifier.ProcessIdentifier, customMembers FultonCustomMembers) (*FultonBootstrap, error) {

	// Construct the metrics OpMonitor
	sampleReporter := telemetry.SampleReporter{
		SampleBuilder:  telemetry.SampleBuilder{ProcessIdentifier: *tPid},
		SampleObserver: customMembers.SampleObserver,
	}

	return &FultonBootstrap{
		Logger:            customMembers.Logger,
		ProcessIdentifier: tPid,
		SampleReporter:    sampleReporter,
	}, nil
}
