package token

import "fmt"

// OAuth is an OAuth Token
type OAuth string

var OAuthEmpty OAuth = ""

func NewOAuth(t string) (OAuth, error) {
	return OAuth(t), nil
}

func (t OAuth) String() string {
	return string(t)
}

func (t OAuth) HeaderValue() string {
	return fmt.Sprintf("OAuth %s", string(t))
}

// JWT is a JSON Web Token
type JWT string

var JWTEmpty JWT = ""

func NewJWT(t string) (JWT, error) {
	return JWT(t), nil
}

func (t JWT) String() string {
	return string(t)
}
