package testutil

import (
	"bytes"
	"io/ioutil"
	"net/http"
)

// CapturedRequestDetails holds details of the http request received by the handler
type CapturedRequestDetails struct {
	Request *http.Request
	Body    []byte
}

// CaptureRequestBodyMiddleware wraps an http.Handler and writes details of the request
// to the provided *CapturedRequestDetails value
func CaptureRequestBodyMiddleware(h http.HandlerFunc, c *CapturedRequestDetails) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		if c == nil {
			h(w, r)
			return
		}

		// have to do this so that the body can "be read twice"
		b, err := ioutil.ReadAll(r.Body)
		r.Body.Close()
		r.Body = ioutil.NopCloser(bytes.NewBuffer(b))
		if err != nil {
			panic("error reading request body")
		}

		// capture request info
		c.Request = r
		c.Body = b

		h(w, r)
	}
}
