package testutil

import (
	"fmt"
	"net/http"
	"time"

	identifier "code.justin.tv/amzn/TwitchProcessIdentifier"
	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	"code.justin.tv/extensions/eastwatch/internal/metrics"

	"code.justin.tv/extensions/eastwatch/internal/fultonlibs/FultonGoLangSimpleBootstrap/simplebootstrap"
)

type MetricsRoundTripper struct {
	wrapped   http.RoundTripper
	bootstrap *simplebootstrap.FultonBootstrap
}

func NewMetricsRoundTripper(rt http.RoundTripper, bs *simplebootstrap.FultonBootstrap) *MetricsRoundTripper {
	return &MetricsRoundTripper{
		wrapped:   rt,
		bootstrap: bs,
	}
}

func (c *MetricsRoundTripper) RoundTrip(req *http.Request) (*http.Response, error) {
	ctx := req.Context()
	d, err := metrics.GetDimensions(ctx)
	if err != nil {
		fmt.Printf("A request is missing Dimensions! %v\n", req)
	}

	if d != (metrics.Dimensions{}) {
		c.bootstrap.SampleReporter.DependencyProcessIdentifier = identifier.ProcessIdentifier{
			Service: d.DependencyServiceName,
			Stage:   "staging",
		}
		c.bootstrap.SampleReporter.DependencyOperationName = d.DependencyOperationName
	}

	startTime := time.Now()
	resp, err := c.wrapped.RoundTrip(req)
	duration := time.Since(startTime)

	if d != (metrics.Dimensions{}) {
		c.bootstrap.SampleReporter.ReportDurationSample("Request Latency", duration)
		c.bootstrap.SampleReporter.Report(string(resp.Status), 1, telemetry.UnitCount)
	}

	return resp, err
}
