package testutil_test

import (
	"strings"
	"testing"

	"code.justin.tv/extensions/eastwatch/internal/testutil"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestUnmarshalTestData(t *testing.T) {

	var v struct {
		Text   string `json:"text"`
		Number int    `json:"number"`
	}

	err := testutil.UnmarshalTestData("unmarshal_testdata.json", &v)

	require.NoError(t, err)
	assert.Equal(t, v.Text, "hi")
	assert.Equal(t, v.Number, 42)
}

func TestUnmarshalReaderJSON(t *testing.T) {

	type example struct {
		Value string `json:"value"`
	}

	t.Run("when the value does not successfully unmarshal, it should error and include the value in the error",
		func(t *testing.T) {

			value := "i am not json"
			r := strings.NewReader(value)
			var s example
			err := testutil.UnmarshalReaderJSON(r, &s)
			require.Error(t, err)
			require.Contains(t, err.Error(), value)
		})

	t.Run("when the value successfully unmarshals, it should not error", func(t *testing.T) {
		value := `{"value":"i am json"}`
		r := strings.NewReader(value)
		var s example
		err := testutil.UnmarshalReaderJSON(r, &s)
		require.NoError(t, err)
		require.Equal(t, "i am json", s.Value)
	})
}
