package testutil

import (
	"code.justin.tv/foundation/twitchclient"
	"net/http"
)

type TwitchClientHeaderSetter struct {
	wrapped http.RoundTripper
}

func TwitchClientTestHeaders(wrapped http.RoundTripper) http.RoundTripper {
	return TwitchClientHeaderSetter{wrapped}
}

func (s TwitchClientHeaderSetter) RoundTrip(req *http.Request) (*http.Response, error) {
	req.Header.Add(twitchclient.TwitchRepositoryHeader, "extensions/eastwatch");
	return s.wrapped.RoundTrip(req);
}

