package users

import (
	"fmt"
	"net/http"
	"strconv"

	"code.justin.tv/extensions/eastwatch/internal/config"

	"code.justin.tv/extensions/eastwatch/internal/api/gql"

	"code.justin.tv/extensions/eastwatch/internal/api/panel"
)

func (u *sandstormUser) CleanUp(cfg config.Configuration, h *http.Client, g gql.Client) error {
	fmt.Println("performing cleanup...")
	_ = u.cleanUpPanels(cfg, h, g)
	_ = u.cleanupInstalledExtensions(cfg, h, g)

	return nil
}

func (u *sandstormUser) cleanUpPanels(cfg config.Configuration, h *http.Client, g gql.Client) error {
	client, err := panel.NewClient(h, cfg.PanelURL)
	if err != nil {
		return err
	}

	panels, err := client.GetChannelPanels(u.ID())
	if err != nil {
		return err
	}

	oat, err := u.OAuthToken(cfg, config.SiteTwilight)
	if err != nil {
		panic("cleanup unable to fetch twilight token")
	}

	for _, panel := range panels {
		_, er := g.DeletePanel(oat, strconv.Itoa(panel.ID))
		if er != nil {
			err = er
		}
	}
	if err != nil {
		return err
	}

	return nil
}

func (u *sandstormUser) cleanupInstalledExtensions(cfg config.Configuration, h *http.Client, g gql.Client) error {
	oat, err := u.OAuthToken(cfg, config.SiteTwilight)
	if err != nil {
		panic("cleanup unable to fetch twilight token")
	}

	r, err := g.GetExtensionsForChannelCurrentUser(oat, u.ID())
	if err != nil {
		return err
	}

	for _, ext := range r.Channel.InstalledExtensions {
		extID, err := g.UninstallExtension(oat, ext.InstallationID)
		if err != nil {
			panic("unable to cleanup installed extensions!")
		}
		fmt.Println("removed extension: " + extID)
	}

	return nil
}
