package legacy_test
/*
import (
	"fmt"
	"path"
	"testing"
	"time"

	"code.justin.tv/extensions/eastwatch/internal/users"

	"code.justin.tv/extensions/eastwatch/internal/api/cartman"
	"code.justin.tv/extensions/eastwatch/internal/api/ems"
	"code.justin.tv/extensions/eastwatch/internal/api/owl"
	"code.justin.tv/extensions/eastwatch/internal/api/visage"
	"code.justin.tv/extensions/eastwatch/internal/config"
	"code.justin.tv/extensions/eastwatch/internal/models/token"
	"code.justin.tv/extensions/eastwatch/test"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/extensions/ems/data"
	"code.justin.tv/gds/gds/extensions/ems/documents"
	cartmanclient "code.justin.tv/web/cartman/client"
	owlclient "code.justin.tv/web/owl/client"
	"github.com/stretchr/testify/suite"
)

func TestExtensionDevWorkflowLegacySuite(t *testing.T) {
	suite.Run(t, new(ExtensionDevWorkflowSuite))
}

// ExtensionDevWorkflowSuite implements and tests a development workflow for creating and activating
// an extension on the developer's own channel using a mixture of visage edge and direct ems calls
type ExtensionDevWorkflowSuite struct {
	test.EastwatchSuite

	Cartman cartman.Client
	EMS     ems.Client
	Visage  visage.Client
	Owl     owl.Client

	// Configured Values
	Config           config.Configuration
	DevUser          users.User
	OAuthDevsite     token.OAuth
	OAuthTwilight    token.OAuth
	ExtensionName    string
	ExtensionVersion string

	// Results
	ExtensionID                          string
	JWT                                  token.JWT
	AppAccessToken                       token.OAuth
	HardDeleteJWT                        token.JWT
	TransitionExtensionStateError        error
	ExtBeforeStateTransition             documents.ExtensionDocument
	ExtAfterStateTransition              documents.ExtensionDocument
	GetExtensionsByChannelIDResult       documents.InstalledExtensionsDocument
	GetExtensionByIDResult               documents.ExtensionDocument
	GetMobileExtensionsByChannelIDResult documents.InstalledExtensionsDocument
}

func (s *ExtensionDevWorkflowSuite) Configure() {
	s.Config = config.Staging
	s.DevUser = users.User3
	s.ExtensionName = fmt.Sprintf("eastwatch-%d", time.Now().Unix())
	s.ExtensionVersion = "0.1.2"

	cc, err := cartmanclient.NewClient(twitchclient.ClientConf{Host: s.Config.CartmanURL})
	s.Require().NoError(err)
	s.Cartman = cartman.NewClient(cc)

	oc, err := owlclient.NewClient(twitchclient.ClientConf{Host: s.Config.OwlURL})
	s.Require().NoError(err)
	s.Owl = owl.NewClient(oc)

	s.EMS, err = ems.NewClient(s.HTTPClient, s.Config.EMSURL)
	s.Require().NoError(err)

	s.Visage, err = visage.NewClient(s.HTTPClient, s.Config.VisageURL)
	s.Require().NoError(err)

	s.OAuthDevsite, err = s.DevUser.OAuthToken(s.Config, config.SiteDevsite)
	s.Require().NoError(err)

	s.OAuthTwilight, err = s.DevUser.OAuthToken(s.Config, config.SiteTwilight)
	s.Require().NoError(err)
}

func (s *ExtensionDevWorkflowSuite) SetupSuite() {
	s.EastwatchSuite.SetupSuite()
	s.Configure()
	s.RunSetups(
		s.CreateExtensionID,
		s.AddExtension,
		s.GetExtensionVersion(func(r documents.ExtensionDocument) {
			s.ExtBeforeStateTransition = r
		}),
		s.TransitionExtensionState,
		s.GetExtensionVersion(func(r documents.ExtensionDocument) {
			s.ExtAfterStateTransition = r
		}),
		s.ObtainCartmanJWT,
		s.ObtainAppAccessToken,
		s.InstallExtension,
		s.ActivateExtension,
		s.GetExtensionsByChannelID,
		s.GetMobileExtensionsByChannelID,
		s.GetExtensionByID,
	)
	s.RunTearDowns()
}

// ====================
// Setup Steps
// --------------------

func (s *ExtensionDevWorkflowSuite) CreateExtensionID() error {
	extID, err := s.Visage.CreateExtensionID(s.OAuthDevsite, s.ExtensionName)
	if err != nil {
		return err
	}

	s.ExtensionID = extID
	s.AddTearDownStep(s.DeleteExtensionID)
	return nil
}

func (s *ExtensionDevWorkflowSuite) AddExtension() error {
	s.AddTearDownStep(s.HardDeleteExtension)

	return s.Visage.AddExtension(s.OAuthDevsite, visage.AddExtensionRequest{
		ExtensionID:      s.ExtensionID,
		ExtensionVersion: s.ExtensionVersion,
		ExtensionName:    s.ExtensionName,
		AuthorID:         s.DevUser.ID(),
		AuthorName:       s.DevUser.Name(),
	})
}

func (s *ExtensionDevWorkflowSuite) TransitionExtensionState() error {
	s.TransitionExtensionStateError = s.Visage.TransitionExtensionState(s.OAuthDevsite, visage.TransitionExtensionStateRequest{
		ExtensionID:      s.ExtensionID,
		ExtensionVersion: s.ExtensionVersion,
		State:            data.ReadyForReview,
	})

	// don't fail setup if this fails
	// assertions around this are below
	return nil
}

func (s *ExtensionDevWorkflowSuite) ObtainCartmanJWT() error {
	jwt, err := s.Cartman.GetToken(
		s.OAuthDevsite,
		[]string{
			cartman.CapExtensionsChannelActivations,
			cartman.CapExtensionsChannelInstalls,
			cartman.CapExtensionsViewAll,
		},
		cartman.ForChannel(s.DevUser.ID()),
		cartman.ForExtension(s.ExtensionID, s.ExtensionVersion),
	)
	if err != nil {
		return err
	}

	s.JWT = jwt
	return nil
}

func (s *ExtensionDevWorkflowSuite) ObtainAppAccessToken() error {
	secret, err := config.GetSandstormSecret(s.Config.SandstormARN, path.Join(s.Config.BaseSandstormPath, s.Config.AppClientSecret))
	s.Require().NoError(err)
	token, err := s.Owl.GetAppAccessToken(s.Config.ClientID, secret)
	if err != nil {
		return err
	}

	s.AppAccessToken = token

	return nil
}

func (s *ExtensionDevWorkflowSuite) InstallExtension() error {
	err := s.EMS.InstallExtension(
		s.JWT,
		ems.InstallExtensionRequest{
			ChannelID:        s.DevUser.ID(),
			ExtensionID:      s.ExtensionID,
			ExtensionVersion: s.ExtensionVersion,
		},
	)
	if err != nil {
		return err
	}

	s.AddTearDownStep(s.UninstallExtension)
	return nil
}

func (s *ExtensionDevWorkflowSuite) ActivateExtension() error {
	return s.EMS.ActivateExtension(
		s.JWT,
		ems.ActivateExtensionRequest{
			ChannelID:        s.DevUser.ID(),
			ExtensionID:      s.ExtensionID,
			ExtensionVersion: s.ExtensionVersion,
			Slot:             ems.SlotExtensionPanel1,
		},
	)
}

func (s *ExtensionDevWorkflowSuite) GetExtensionVersion(setter func(documents.ExtensionDocument)) func() error {
	return func() error {
		r, err := s.Visage.GetExtensionVersion(s.OAuthDevsite, s.ExtensionID, s.ExtensionVersion)
		if err != nil {
			return err
		}

		setter(r)
		return err
	}
}

func (s *ExtensionDevWorkflowSuite) GetExtensionsByChannelID() error {
	r, err := s.Visage.GetExtensionsByChannelID(s.OAuthTwilight, s.DevUser.ID())
	if err != nil {
		return err
	}

	s.GetExtensionsByChannelIDResult = r
	return err
}

func (s *ExtensionDevWorkflowSuite) GetExtensionByID() error {
	r, err := s.Visage.GetExtensionByID(s.OAuthTwilight, s.ExtensionID, s.ExtensionVersion)
	if err != nil {
		return err
	}

	s.GetExtensionByIDResult = r
	return err
}

func (s *ExtensionDevWorkflowSuite) GetMobileExtensionsByChannelID() error {
	r, err := s.Visage.GetMobileExtensionsByChannelID(s.OAuthTwilight, s.DevUser.ID())
	if err != nil {
		return err
	}

	s.GetMobileExtensionsByChannelIDResult = r
	return err
}

// ====================
// TearDown Steps
// --------------------

func (s *ExtensionDevWorkflowSuite) UninstallExtension() error {
	s.T().Logf("Uninstalling extension %s\n..", s.ExtensionID)
	return s.EMS.UninstallExtension(
		s.JWT,
		ems.UninstallExtensionRequest{
			ChannelID:        s.DevUser.ID(),
			ExtensionID:      s.ExtensionID,
			ExtensionVersion: s.ExtensionVersion,
		},
	)
}

func (s *ExtensionDevWorkflowSuite) GetCartmanHardDeleteJWT() (token.JWT, error) {
	s.T().Logf("Fetching Hard Delete Token...")
	return s.Cartman.GetToken(s.AppAccessToken,
		[]string{
			cartman.CapExtensionsViewAll,
			cartman.CapExtensionsHardDelete,
		})
}

func (s *ExtensionDevWorkflowSuite) HardDeleteExtension() error {
	// Hard Delete JWTs expire quickly, so we're going to request them as needed
	token, err := s.GetCartmanHardDeleteJWT()
	s.T().Logf("Hard Deleting %s...\n", s.ExtensionID)
	s.Require().NoError(err)
	s.EMS.HardDeleteExtension(token, s.ExtensionID)

	return nil
}

func (s *ExtensionDevWorkflowSuite) DeleteExtensionID() error {
	return s.Owl.DeleteClient(s.DevUser.ID(), s.ExtensionID)
}

// ====================
// Tests (Assertions)
// --------------------

func (s *ExtensionDevWorkflowSuite) Test_TransitionExtensionState() {
	s.Run("should not error", func() {
		s.Require().NoError(s.TransitionExtensionStateError)
	})

	s.Run("should successfully transition the extension state", func() {
		s.Equal(data.InTest.ToHumanName(), s.ExtBeforeStateTransition.State, fmt.Sprintf("%+v", s.ExtBeforeStateTransition))
		s.Equal(data.ReadyForReview.ToHumanName(), s.ExtAfterStateTransition.State, fmt.Sprintf("%+v", s.ExtAfterStateTransition))
	})
}

func (s *ExtensionDevWorkflowSuite) Test_GetExtensionsByChannelID() {
	s.Run("should contain the newly created extension", func() {
		exts := s.GetExtensionsByChannelIDResult.InstalledExtensions
		if len(exts) != 1 {
			//Retry
			s.T().Logf("Repull list of extensions")
			//Adding buffer between calls to reduce 409 issues
			time.Sleep(time.Duration(250) * time.Millisecond)
			exts = s.GetExtensionsByChannelIDResult.InstalledExtensions
		}
		s.Require().Len(exts, 1)
		ext := exts[0].Extension
		s.Equal(s.ExtensionID, ext.ID)
		s.Equal(s.ExtensionName, ext.Name)
	})
}

func (s *ExtensionDevWorkflowSuite) Test_GetExtensionByID() {
	s.Run("should contain the extension", func() {
		s.Equal(s.ExtensionID, s.GetExtensionByIDResult.ID)
		s.Equal(s.ExtensionVersion, s.GetExtensionByIDResult.Version)
	})
}

func (s *ExtensionDevWorkflowSuite) Test_GetMobileExtensionsByChannelID() {
	s.Run("should not contain a mobile extension", func() {
		s.Require().Empty(s.GetMobileExtensionsByChannelIDResult.InstalledExtensions)
	})
}


 */