package legacy_test
/*
import (
	"fmt"
	"net/http"
	"testing"
	"time"

	"code.justin.tv/extensions/eastwatch/internal/metrics"

	"code.justin.tv/extensions/eastwatch/internal/api/visage"
	"code.justin.tv/extensions/eastwatch/internal/config"
	"code.justin.tv/extensions/eastwatch/internal/testutil"
	"code.justin.tv/extensions/eastwatch/internal/users"
	"code.justin.tv/gds/gds/extensions/ems/documents"
	"github.com/stretchr/testify/require"
)

func TestGetExtensionByChannelID(t *testing.T) {

	cfg := config.Staging
	bs, err := metrics.InitBootStrap("Eastwatch")
	if err != nil {
		panic(fmt.Sprintf("unable to initialize stats! %v", err))
	}
	captured := testutil.NewRoundTripRecorder(
		testutil.NewMetricsRoundTripper(http.DefaultTransport, bs))
	httpClient := &http.Client{
		Timeout:   2 * time.Second,
		Transport: captured,
	}

	client, err := visage.NewClient(httpClient, cfg.VisageURL)
	require.NoError(t, err)

	collectIDs := func(doc documents.InstalledExtensionsDocument) []string {
		ids := make([]string, len(doc.InstalledExtensions))
		for i, ext := range doc.InstalledExtensions {
			ids[i] = ext.Extension.ID
		}
		return ids
	}

	t.Run("channel with 0 extensions", func(t *testing.T) {
		doc, err := client.GetExtensionsByChannelID("", users.User1.ID())
		require.NoError(t, err)
		require.Empty(t, doc.InstalledExtensions)
	})

	t.Run("channel with 1 extension", func(t *testing.T) {
		doc, err := client.GetExtensionsByChannelID("", "100284896")
		require.NoError(t, err)
		require.Len(t, doc.InstalledExtensions, 1)
		require.ElementsMatch(t, []string{
			"zfh2irvx2jb4s60f02jq0ajm8vwgka",
		}, collectIDs(doc))
	})

	t.Run("channel with 3 extensions", func(t *testing.T) {
		doc, err := client.GetExtensionsByChannelID("", "30841377")
		require.NoError(t, err)
		require.Len(t, doc.InstalledExtensions, 3)
		require.ElementsMatch(t, []string{
			"24u62kim5mn0slhwigdt7v4ybkwef5",
			"87rjb2p3ax33dxyxic3j0vrrtrs2dm",
			"rh6jq1q334hqc2rr1qlzqbvwlfl3x0",
		}, collectIDs(doc))
	})

	bs.SampleReporter.Stop()
}
*/
