// Code generated by ./internal/GenerateConfig. DO NOT EDIT.
//+build !generate

package c7s

// Merge another configuration into this one.
func (cfg *Config) Merge(other *Config) *Config{

	if other.ClientServiceName != "" {
		cfg.ClientServiceName = other.ClientServiceName
	}

	if other.ServiceOrigins != "" {
		cfg.ServiceOrigins = other.ServiceOrigins
	}

	if other.AccessTokenCacheSize != 0 {
		cfg.AccessTokenCacheSize = other.AccessTokenCacheSize
	}

	if other.ClientServiceURI != "" {
		cfg.ClientServiceURI = other.ClientServiceURI
	}

	if other.EnableAccessLogging != false {
		cfg.EnableAccessLogging = other.EnableAccessLogging
	}

	if other.AWSRegion != "" {
		cfg.AWSRegion = other.AWSRegion
	}

	if other.ServiceURIByNameBase != "" {
		cfg.ServiceURIByNameBase = other.ServiceURIByNameBase
	}

	if other.CalleeRealm != "" {
		cfg.CalleeRealm = other.CalleeRealm
	}

	if other.DiscoveryEndpoint != "" {
		cfg.DiscoveryEndpoint = other.DiscoveryEndpoint
	}

	if other.Issuer != "" {
		cfg.Issuer = other.Issuer
	}

	if other.TokenScope != "" {
		cfg.TokenScope = other.TokenScope
	}

	return cfg
}

// Validate returns an error if attributes are missing
func (cfg *Config) Validate() error {
	missing := []string{}

	if cfg.AccessTokenCacheSize == 0 {
		missing = append(missing, "AccessTokenCacheSize")
	}

	if cfg.AWSRegion == "" {
		missing = append(missing, "AWSRegion")
	}

	if cfg.ServiceURIByNameBase == "" {
		missing = append(missing, "ServiceURIByNameBase")
	}

	if cfg.CalleeRealm == "" {
		missing = append(missing, "CalleeRealm")
	}

	if cfg.DiscoveryEndpoint == "" {
		missing = append(missing, "DiscoveryEndpoint")
	}

	if cfg.Issuer == "" {
		missing = append(missing, "Issuer")
	}

	if cfg.TokenScope == "" {
		missing = append(missing, "TokenScope")
	}

  if err := cfg.validateSpecialCases(); err != nil {
    if mergable, ok := err.(errMissingConfigurationMergable); ok {
      mergable.addAttributes(missing)
    }
    return err
  }

	if len(missing) > 0 {
		return newErrMissingConfiguration(missing...)
	}
	return nil
}
