package instrumentation

// Frequency is a hint to an Instrumentor about how often an Event is expected to occur
type Frequency string

const (
	// Rare -- should be used for things that aren't part of common viewer/broadcaster use
	Rare Frequency = "rare"
	// Common -- should be used for things that viewers/broadcasters use periodically
	Common Frequency = "common"
	// Frequent -- should be used for things that will be repeated on a per-viewer/broadcaster basis
	Frequent Frequency = "frequent"
)
