package instrumentation

import (
	"context"
	"net/http"
)

type statusWriter struct {
	inner  http.ResponseWriter
	status int
	ctx    context.Context
}

type ContextStorable interface {
	SetCtx(ctx context.Context)
}

var _ ContextStorable = new(statusWriter)

func (s *statusWriter) Header() http.Header {
	return s.inner.Header()
}

func (s *statusWriter) Write(a []byte) (int, error) {
	written, err := s.inner.Write(a)
	if err == nil && s.status == 0 {
		s.status = http.StatusOK
	}
	return written, err
}

func (s *statusWriter) WriteHeader(status int) {
	s.inner.WriteHeader(status)
	s.status = status
}

func (s *statusWriter) SetCtx(ctx context.Context) {
	s.ctx = ctx
}
