package auth

import (
	"net/http"
)

// FakeHandler serves its Credentials field or NoPermissions() if that
// field is not set.
type FakeHandler struct {
	Credentials Credentials
}

// GetCredentials implements Handler
func (f *FakeHandler) GetCredentials(r *http.Request) (Credentials, error) {
	if f.Credentials == nil {
		return NoPermissions(), nil
	}
	return f.Credentials, nil
}

// NewFakeCredentials returns legacy client test compliant settings.
// TODO: kill once client tests properly send auth
func NewFakeCredentials(allow bool, userID string) Credentials {
	return buildClientTestFake(allow, allow, userID)
}

// NewFakeCredentialsWithRole returns legacy client test compliant settings.
// TODO: kill once client tests properly send auth
func NewFakeCredentialsWithRole(approver bool, userID string) Credentials {
	return buildClientTestFake(true, approver, userID)
}

// This is convoluted, but it's the backward compatible thing client tests expect
// In related news, auth success/failure in our client tests does not predict auth
// success/failure in production well.
const mostPowerfulUserID = "74681932"
const moderatorUserID = "148547479"

func buildClientTestFake(mostPowers bool, approver bool, userID string) Credentials {
	creds := &FakeCredentials{UserIDValue: userID}
	if approver {
		creds.Role = creds.Role | Reviewer | Installer | Seer
	}
	if mostPowers {
		creds.Role = creds.Role | Developer | Creator
		creds.AllowChannelID = "*"
		creds.OwnedExtensions = []string{"*"}
	}
	if userID == moderatorUserID {
		creds.Role = creds.Role | Moderator
	}
	if userID == mostPowerfulUserID {
		creds.Role = creds.Role | Cleric | Moderator
	}

	return creds
}
