package auth

// FakePermissions are used for tests
type FakePermissions struct {
	AllowExternalContentLink  bool
	AllowMobileDisplay        bool
	AllowInstallAllExtensions bool
	AllowMonetization         bool
	AllowSubscriptionStatus   bool
}

var _ Permissions = &FakePermissions{}

// CanLinkExternalContent checks if you can outbound link
func (f *FakePermissions) CanLinkExternalContent(clientID string) bool {
	return f.AllowExternalContentLink
}

// CanDisplayMobileView checks if you can display the mobile view
func (f *FakePermissions) CanDisplayMobileView(creds Credentials, clientID string) bool {
	return creds.CanSkipMobileCheck(clientID) || f.AllowMobileDisplay
}

// CanInstallAllExtensions checks if a channel can bypass the extension channel whitelist
func (f *FakePermissions) CanInstallAllExtensions(channelID string) bool {
	return f.AllowInstallAllExtensions
}

// CanMonetize checks if a the given channel has access to monetization (isPartner/isAffiliate)
func (f *FakePermissions) CanMonetize(channelID string) bool {
	return f.AllowMonetization
}

// CanCheckSubscriptionStatus checks if the given oauthToken is still valid for the channelID/extensionClientID
func (f *FakePermissions) CanCheckSubscriptionStatus(extensionClientID, channelID string) bool {
	return f.AllowSubscriptionStatus
}
