package auth

import (
	"context"

	wauth "code.justin.tv/gds/gds/extensions/whitelist/auth"
	wdata "code.justin.tv/gds/gds/extensions/whitelist/data"
	wp "code.justin.tv/gds/gds/extensions/whitelist/protocol"
)

type whitelistAdapter struct {
	manager wdata.WhitelistManager
}

func newWhitelistAdapter(manager wdata.WhitelistManager) *whitelistAdapter {
	ctx := wauth.Store(context.Background(), &FakeCredentials{Role: Authorizer})
	return &whitelistAdapter{manager.WithContext(ctx)}
}

func (w *whitelistAdapter) HasMember(action wp.Action, creds Credentials) bool {
	member := createWhitelistMember(creds)
	wl, err := w.manager.Whitelist(action)
	if err != nil {
		return false
	}
	found, err := wl.HasMember(member)
	return found && err == nil
}

func (w *whitelistAdapter) HasUser(action wp.Action, userID string) bool {
	wl, err := w.manager.Whitelist(action)
	if err != nil {
		return false
	}
	found, err := wl.HasMember(wp.UserMember(userID))
	return found && err == nil
}

func (w *whitelistAdapter) HasClient(action wp.Action, clientID string) bool {
	wl, err := w.manager.Whitelist(action)
	if err != nil {
		return false
	}
	found, err := wl.HasMember(wp.ClientMember(clientID))
	return found && err == nil
}

func (w *whitelistAdapter) IsEditor(action wp.Action, creds Credentials) bool {
	editWhitelistAction := wp.EditWhitelist(action)
	return w.HasMember(editWhitelistAction, creds)
}

func (w *whitelistAdapter) IsViewer(action wp.Action, creds Credentials) bool {
	viewWhitelistAction := wp.ViewWhitelist(action)
	return w.HasMember(viewWhitelistAction, creds)
}

func createWhitelistMember(creds Credentials) wp.Member {
	if creds.UserID() != nil {
		return wp.UserMember(*creds.UserID())
	}
	return wp.ClientMember(creds.ClientID())
}
