package messages

import "code.justin.tv/gds/gds/golibs/event"

// set up message factory for this package - declare a variable at top scope
// to import serialization of all message types..
func BuildFactory() *event.MessageFactory {
	f := event.NewMessageFactory()
	RegisterWithFactory(f)
	return f
}

func SupportedVersions(topic event.Topic) []int {
	switch topic {
	case ChannelTopic:
		return []int{1}
	case ExtensionTopic:
		return []int{1}
	case AssetTopic:
		return []int{1}
	}
	return []int{}
}

// Append these messages to an existing factory
func RegisterWithFactory(f *event.MessageFactory) {
	f.Register(ChannelTopic, OnInstalled, SupportedVersions(ChannelTopic), LoadChannelMessage)
	f.Register(ChannelTopic, OnUninstalled, SupportedVersions(ChannelTopic), LoadChannelMessage)
	f.Register(ChannelTopic, OnActivated, SupportedVersions(ChannelTopic), LoadChannelMessage)
	f.Register(ChannelTopic, OnDynamicActivated, SupportedVersions(ChannelTopic), LoadChannelMessage)
	f.Register(ChannelTopic, OnDeactivated, SupportedVersions(ChannelTopic), LoadChannelMessage)
	f.Register(ChannelTopic, OnDynamicDeactivated, SupportedVersions(ChannelTopic), LoadChannelMessage)
	f.Register(ChannelTopic, OnConfigured, SupportedVersions(ChannelTopic), LoadChannelMessage)
	f.Register(ChannelTopic, OnDynamicInstalled, SupportedVersions(ChannelTopic), LoadChannelMessage)
	f.Register(ChannelTopic, OnDynamicEnrolled, SupportedVersions(ChannelTopic), LoadChannelMessage)
	f.Register(ChannelTopic, OnDynamicUninstalled, SupportedVersions(ChannelTopic), LoadChannelMessage)
	f.Register(ChannelTopic, OnDynamicUnenrolled, SupportedVersions(ChannelTopic), LoadChannelMessage)
	f.Register(ChannelTopic, OnManualDynamicUnenrolled, SupportedVersions(ChannelTopic), LoadChannelMessage)
	f.Register(ChannelTopic, OnPermsAllowed, SupportedVersions(ChannelTopic), LoadChannelMessage)
	f.Register(ChannelTopic, OnPermsDenied, SupportedVersions(ChannelTopic), LoadChannelMessage)
	f.Register(ChannelTopic, OnAnchorChanged, SupportedVersions(ChannelTopic), LoadChannelMessage)
	f.Register(ChannelTopic, OnMaybeActivated, SupportedVersions(ChannelTopic), LoadChannelMessage)
	f.Register(ChannelTopic, OnDynamicMaybeActivated, SupportedVersions(ChannelTopic), LoadChannelMessage)

	f.Register(ExtensionTopic, OnCreated, SupportedVersions(ExtensionTopic), LoadExtensionMessage)
	f.Register(ExtensionTopic, OnModified, SupportedVersions(ExtensionTopic), LoadExtensionMessage)
	f.Register(ExtensionTopic, OnDeleted, SupportedVersions(ExtensionTopic), LoadExtensionMessage)
	f.Register(ExtensionTopic, OnCreated, SupportedVersions(ExtensionTopic), LoadExtensionMessage)
	f.Register(ExtensionTopic, OnTransitioned, SupportedVersions(ExtensionTopic), LoadExtensionMessage)
	f.Register(ExtensionTopic, OnMassDeactivated, SupportedVersions(ExtensionTopic), LoadExtensionMessage)

	f.Register(AssetTopic, OnSaved, SupportedVersions(AssetTopic), LoadAssetInfoMessage)
	f.Register(AssetTopic, OnModified, SupportedVersions(AssetTopic), LoadAssetInfoMessage)
}
