package messages

type PushyEvent string

const (
	PushyNoEvent     = PushyEvent("")
	PushyApproved    = PushyEvent("approved")
	PushyDeactivated = PushyEvent("deactivated")
	PushyDeleted     = PushyEvent("deleted")
	PushyRejected    = PushyEvent("rejected")
	PushyReleased    = PushyEvent("released")
)

type PushyCommon struct {
	Email            string `json:"email"`
	ExtensionID      string `json:"extension_id"`
	ExtensionName    string `json:"extension_name"`
	ExtensionVersion string `json:"extension_version"`
}

type PushyMessage struct {
	Common            PushyCommon `json:"common"`
	Reason            string      `json:"reason,omitempty"`
	DeprecatedVersion string      `json:"deprecated_version,omitempty"`
}

func NewPushyMessage(ev PushyEvent, msg *ExtensionMessage) *PushyMessage {
	ext := msg.Extension
	out := &PushyMessage{
		Common: PushyCommon{
			Email:            ext.AuthorEmail,
			ExtensionID:      ext.ID,
			ExtensionName:    ext.Name,
			ExtensionVersion: ext.Version,
		},
	}
	switch ev {
	case PushyApproved:
		// no additional fields
	case PushyDeleted:
		// no additional fields
	case PushyRejected:
		out.Reason = "Staff Action"
	case PushyReleased:
		out.DeprecatedVersion = msg.DeprecatedVersion
	}
	return out
}
